package pl.gda.pg.concurrency.atomicity;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class BlockinQueueDemo {

    class Producer implements Runnable {
        private final BlockingQueue queue;

        Producer(BlockingQueue q) {
            queue = q;
        }

        public void run() {
            try {
                for(int i=0; i<10; i++){
                    queue.put(produce());
                    Thread.sleep(1000);
                }
            } catch (InterruptedException ex) {
            }
        }

        Object produce() {
            Object obj = new Object();
            System.out.println("Producer id 0: " + obj);
            return obj;
        }
    }

    class Consumer implements Runnable {
        private final BlockingQueue queue;
        private int id;

        Consumer(BlockingQueue q, int id) {
            queue = q;
            this.id = id;
        }

        public void run() {
            try {
                while (true) {
                    consume(queue.take());
                }
            } catch (InterruptedException ex) {
            }
        }

        void consume(Object x) {
            System.out.println("Consumer id " + id + ": " + x);
        }
    }

    public void showDemo() {
        BlockingQueue q = new ArrayBlockingQueue(10);
        Producer p = new Producer(q);
        Consumer c1 = new Consumer(q, 1);
        Consumer c2 = new Consumer(q, 2);
        new Thread(p).start();
        new Thread(c1).start();
        new Thread(c2).start();
    }
}


